/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.X509AttributeName;

public class CRLExtensions {
    private Hashtable map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    static Class class$java$lang$Boolean;
    static Class class$java$lang$Object;

    public int hashCode() {
        return this.map.hashCode();
    }

    public CRLExtensions() {
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public void decode(InputStream inputStream) throws CRLException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.isContextSpecific((byte)0)) {
                this.init(derValue.data);
            } else {
                this.init(new DerInputStream(derValue.toByteArray()));
            }
        }
        catch (IOException iOException) {
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    public void encode(OutputStream outputStream, boolean bl2) throws CRLException {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            Collection collection = this.map.values();
            Object[] objectArray = collection.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] instanceof CertAttrSet) {
                    ((CertAttrSet)objectArray[i2]).encode(derOutputStream);
                    continue;
                }
                if (objectArray[i2] instanceof Extension) {
                    ((Extension)objectArray[i2]).encode(derOutputStream);
                    continue;
                }
                throw new CRLException("Illegal extension object");
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            DerOutputStream derOutputStream3 = new DerOutputStream();
            if (bl2) {
                derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
            } else {
                derOutputStream3 = derOutputStream2;
            }
            outputStream.write(derOutputStream3.toByteArray());
        }
        catch (IOException iOException) {
            throw new CRLException("Encoding error: " + iOException.toString());
        }
        catch (CertificateException certificateException) {
            throw new CRLException("Encoding error: " + certificateException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CRLExtensions)) {
            return false;
        }
        Collection collection = ((CRLExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Extension extension;
            if (objectArray[i2] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i2]).getName();
            }
            Extension extension2 = (Extension)objectArray[i2];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)this.map.get(string)) == null) {
                return false;
            }
            if (extension.equals(extension2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.map.toString();
    }

    public void delete(String string) {
        this.map.remove(string);
    }

    public Collection getAllExtensions() {
        return this.map.values();
    }

    public Enumeration getElements() {
        return this.map.elements();
    }

    public CRLExtensions(DerInputStream derInputStream) throws CRLException {
        this.init(derInputStream);
    }

    private void init(DerInputStream derInputStream) throws CRLException {
        try {
            Object object;
            DerInputStream derInputStream2 = derInputStream;
            byte by = (byte)derInputStream.peekByte();
            if ((by & 0xC0) == 128 && (by & 0x1F) == 0) {
                object = derInputStream2.getDerValue();
                derInputStream2 = object.data;
            }
            object = derInputStream2.getSequence(5);
            for (int i2 = 0; i2 < ((DerValue[])object).length; ++i2) {
                Extension extension = new Extension(object[i2]);
                this.parseExtension(extension);
            }
        }
        catch (IOException iOException) {
            throw new CRLException("Parsing error: " + iOException.toString());
        }
    }

    private void parseExtension(Extension extension) throws CRLException {
        try {
            Class clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) != null) {
                    throw new CRLException("Duplicate extensions not allowed");
                }
                return;
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CRLExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CRLExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n2 = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Array.setByte(object, i2, byArray[i2]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), certAttrSet) != null) {
                throw new CRLException("Duplicate extensions not allowed");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CRLException(invocationTargetException.getTargetException().getMessage());
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void set(String string, Object object) {
        this.map.put(string, object);
    }

    public Extension get(String string) {
        String string2;
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string3 = x509AttributeName.getPrefix();
        if (string3.equalsIgnoreCase("x509")) {
            int n2 = string.lastIndexOf(".");
            string2 = string.substring(n2 + 1);
        } else {
            string2 = string;
        }
        return (Extension)this.map.get(string2);
    }
}

